package semestralka;

import java.io.File;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author not attributable
 * @version 1.0
 */
public class Parser {
    private LexAn lex = null;
    private IdentTab tab = null;

    public Parser(File file) {
        lex = new LexAn(file);
        tab = new IdentTab();
    }

    public MainNode program() {
        MainNode res = new MainNode();
        while((lex.getSymb() == LexAn.hash) || (lex.getSymb() == LexAn.bc) || (lex.getSymb() == LexAn.kw) || (lex.getSymb() == LexAn.nl)) {
            switch (lex.getSymb()) {
            case LexAn.EOF:
                return res;
            case LexAn.hash:
                lex.srovnej(LexAn.hash);
                res.addNode(preprocesor());
                break;
            case LexAn.bc:
                lex.srovnej(LexAn.bc);
                res.addNode(new BigComment(lex.srovnejString("*/")));
                break;
            case LexAn.kw:
                res.addNode(new KeyTyp(lex.srovnejKw()));
                res.addNode(definice());
                break;
            case LexAn.nl:
                lex.srovnej(LexAn.nl);
                res.addNode(new NewLine());
                break;
            default:
                System.out.println("Ocekavan #, /*, kwTyp, nl");
                System.out.println("Pozice: " + lex.getPos());
                System.exit(1);
            }
        }
        return res;
    }

    private Node preprocesor () {
        Preprocesor act = new Preprocesor();
        switch(lex.getSymb()) {
        case LexAn.include:
            lex.srovnej(LexAn.include);
            act.setKw("include");
            switch(lex.getSymb()) {
            case LexAn.mensi:
                lex.srovnej(LexAn.mensi);
                act.setWhat("&lt;" + lex.srovnejString(">"));
                lex.srovnej(LexAn.nl);
                break;
            case LexAn.uvozovky:
                lex.srovnej(LexAn.uvozovky);
                act.setWhat("\"" + lex.srovnejString("\""));
                lex.srovnej(LexAn.nl);
                break;
            default:
                System.out.println("Ocekavan \", <");
                System.out.println("Pozice: " + lex.getPos());
                System.exit(1);
            }
            break;
        case LexAn.define:
            lex.srovnej(LexAn.define);
            act.setKw("define");
            if(lex.getSymb() != LexAn.ident) {
                System.out.println("Ocekavan identifikator");
                System.out.println("Pozice: " + lex.getPos());
                System.exit(1);
            }
            String i = lex.srovnejIdent();
            String a = lex.srovnejString("\n");
            if((a != null) && (a.trim().length() > 0)) {
                int n = tab.newIdent(i);
                act.setIdent(new Ident(n, "", i));
                act.setAppend(a);
            }
            else {
                act.setWhat(i);
            }
            break;
        default:
            System.out.println("Ocekavan include, define");
            System.out.println("Pozice: " + lex.getPos());
            System.exit(1);
        }
        return act;
    }

    private Node definice() {
        String pointer = "";
        while(lex.getSymb() == LexAn.krat) {
            pointer += "*";
            lex.srovnej(LexAn.krat);
        }
        String i = lex.srovnejIdent();
        int n = tab.newIdent(i);
        Ident id = new Ident(n, pointer, i);
        switch(lex.getSymb()) {
        case LexAn.lzavorka:
            lex.srovnej(LexAn.lzavorka);
            int mark = tab.setMark();
            id.setParam(listIdent());
            lex.srovnej(LexAn.pzavorka);
            id.addNode(prikaz());
            tab.clearAfterMark(mark);
            break;
        default:
            while(lex.getSymb() == LexAn.carka) {
                lex.srovnej(LexAn.carka);
                id.addNode(new Carka());
                pointer = "";
                while(lex.getSymb() == LexAn.krat) {
                    pointer += "*";
                    lex.srovnej(LexAn.krat);
                }
                i = lex.srovnejIdent();
                n = tab.newIdent(i);
                id.addNode(new Ident(n, pointer, i));
            }
            lex.srovnej(LexAn.strednik);
            id.addNode(new Strednik());
            break;
        }
        return id;
    }

    private Node listIdent() {
        Node res = null;
        if(lex.getSymb() == LexAn.kw) {
            res = new KeyTyp(lex.srovnejKw());
            String pointer = "";
            while (lex.getSymb() == LexAn.krat) {
                pointer += "*";
                lex.srovnej(LexAn.krat);
            }
            String i = lex.srovnejIdent();
            int n = tab.newIdent(i);
            res.addNode(new Ident(n, pointer, i));
            while(lex.getSymb() == LexAn.carka) {
                lex.srovnej(LexAn.carka);
                res.addNode(new Carka());
                res.addNode(new KeyTyp(lex.srovnejKw()));
                pointer = "";
                while (lex.getSymb() == LexAn.krat) {
                    pointer += "*";
                    lex.srovnej(LexAn.krat);
                }
                i = lex.srovnejIdent();
                n = tab.newIdent(i);
                res.addNode(new Ident(n, pointer, i));
            }
        }
        return res;
    }

    private Node prikaz() {
        Node res = null;
        switch(lex.getSymb()) {
        case LexAn.kw:
            res = new KeyTyp(lex.srovnejKw());
            String pointer = "";
            while (lex.getSymb() == LexAn.krat) {
                pointer += "*";
                lex.srovnej(LexAn.krat);
            }
            String i = lex.srovnejIdent();
            int n = tab.newIdent(i);
            res.addNode(new Ident(n, pointer, i));
            while(lex.getSymb() == LexAn.carka) {
                lex.srovnej(LexAn.carka);
                res.addNode(new Carka());
                pointer = "";
                while (lex.getSymb() == LexAn.krat) {
                    pointer += "*";
                    lex.srovnej(LexAn.krat);
                }
                i = lex.srovnejIdent();
                n = tab.newIdent(i);
                res.addNode(new Ident(n, pointer, i));
            }
            lex.srovnej(LexAn.strednik);
            res.addNode(new Strednik());
           break;
        case LexAn.ident:
            i = lex.srovnejIdent();
            n = tab.isIn(i);
            res = new Ident(n, "", i, true);
            switch(lex.getSymb()) {
            case LexAn.rovnase:
                lex.srovnej(LexAn.rovnase);
                res.addNode(new Rovnase());
                res.addNode(vyraz());
                break;
            case LexAn.lzavorka:
                lex.srovnej(LexAn.lzavorka);
                ((Ident) res).setParam(inListIdent());
                lex.srovnej(LexAn.pzavorka);
                break;
            default:
                System.out.println("Ocekavan =, (");
                System.out.println("Pozice: " + lex.getPos());
                System.exit(1);
            }
            lex.srovnej(LexAn.strednik);
            res.addNode(new Strednik());
            break;
        case LexAn.krat:
            pointer = "*";
            lex.srovnej(LexAn.krat);
            while (lex.getSymb() == LexAn.krat) {
                pointer += "*";
                lex.srovnej(LexAn.krat);
            }
            i = lex.srovnejIdent();
            n = tab.isIn(i);
            res = new Ident(n, pointer, i, true);
            lex.srovnej(LexAn.rovnase);
            res.addNode(new Rovnase());
            res.addNode(vyraz());
            lex.srovnej(LexAn.strednik);
            res.addNode(new Strednik());
           break;
        case LexAn.kwfor:
            lex.srovnej(LexAn.kwfor);
            Node ident = null, podm = null, com = null;
            lex.srovnej(LexAn.lzavorka);
            if(lex.getSymb() == LexAn.ident) {
                i = lex.srovnejIdent();
                n = tab.isIn(i);
                ident = new Ident(n, "", i, true);
                lex.srovnej(LexAn.rovnase);
                ident.addNode(new Rovnase());
                ident.addNode(vyraz());
            }
            lex.srovnej(LexAn.strednik);
            if((lex.getSymb() == LexAn.uvozovky) || (lex.getSymb() == LexAn.num) || (lex.getSymb() == LexAn.krat) || (lex.getSymb() == LexAn.ident)) {
                podm = podm();
            }
            lex.srovnej(LexAn.strednik);
            if(lex.getSymb() == LexAn.ident) {
                i = lex.srovnejIdent();
                n = tab.isIn(i);
                com = new Ident(n, "", i, true);
                lex.srovnej(LexAn.rovnase);
                com.addNode(new Rovnase());
                com.addNode(vyraz());
            }
            lex.srovnej(LexAn.pzavorka);
            res = new KeyFor(ident, podm, com, prikaz());
            break;
        case LexAn.kwif:
            lex.srovnej(LexAn.kwif);
            lex.srovnej(LexAn.lzavorka);
            podm = podm();
            lex.srovnej(LexAn.pzavorka);
            res = new KeyIf(podm, prikaz());
            if(lex.getSymb() == LexAn.kwelse) {
                lex.srovnej(LexAn.kwelse);
                ((KeyIf) res).setElse(prikaz());
            }
            break;
        case LexAn.kwwhile:
            lex.srovnej(LexAn.kwwhile);
            lex.srovnej(LexAn.lzavorka);
            podm = podm();
            lex.srovnej(LexAn.pzavorka);
            res = new KeyWhile(podm, prikaz());
            break;
        case LexAn.kwreturn:
            lex.srovnej(LexAn.kwreturn);
            res = new KeyReturn(vyraz());
            lex.srovnej(LexAn.strednik);
            res.addNode(new Strednik());
            break;
        case LexAn.strednik:
            lex.srovnej(LexAn.strednik);
            res = new Strednik();
            break;
        case LexAn.nl:
            lex.srovnej(LexAn.nl);
            res = new NewLine();
            break;
        case LexAn.lslozena:
            lex.srovnej(LexAn.lslozena);
            int mark = tab.setMark();
            res = new Blok();
            Node pom;
            while((pom = prikaz()) != null) {
                ((Blok) res).addInner(pom);
            }
            lex.srovnej(LexAn.pslozena);
            tab.clearAfterMark(mark);
            break;
        case LexAn.pslozena:
            return null;
        default:
            System.out.println("Ocekavan {, kwTyp, ident, for, if, while, ;");
            System.out.println("Pozice: " + lex.getPos());
            System.exit(1);
        }
        return res;
    }

    private Node vyraz() {
        Node res = operand();
        while(lex.getSymb() == LexAn.op) {
            String op = lex.srovnejOp();
            res.addNode(new Op(op));
            res.addNode(operand());
        }
        return res;
    }

    private Node inListIdent() {
        Node res = null;
        if((lex.getSymb() == LexAn.uvozovky) || (lex.getSymb() == LexAn.num) || (lex.getSymb() == LexAn.krat) || (lex.getSymb() == LexAn.ident)) {
            res = operand();
            while (lex.getSymb() == LexAn.carka) {
                lex.srovnej(LexAn.carka);
                res.addNode(new Carka());
                res.addNode(operand());
            }
        }
        return res;
    }

    private Node podm() {
        Node res = operand();
        String op = lex.srovnejComOp();
        res.addNode(new Op(op));
        res.addNode(operand());
        return res;
    }

    private Node operand() {
        Node res = null;
        switch(lex.getSymb()) {
        case LexAn.uvozovky:
            lex.srovnej(LexAn.uvozovky);
            res = new Retezec("\"" + lex.srovnejString("\""));
            break;
        case LexAn.num:
            res = new Num(lex.srovnejNum());
            break;
        case LexAn.ident:
            String i = lex.srovnejIdent();
            int n = tab.isIn(i);
            res = new Ident(n, "", i, true);
            if(lex.getSymb() == LexAn.lzavorka) {
                lex.srovnej(LexAn.lzavorka);
                ((Ident) res).setParam(inListIdent());
                lex.srovnej(LexAn.pzavorka);
            }
            break;
        case LexAn.krat:
            String pointer = "*";
            lex.srovnej(LexAn.krat);
            while (lex.getSymb() == LexAn.krat) {
                pointer += "*";
                lex.srovnej(LexAn.krat);
            }
            i = lex.srovnejIdent();
            n = tab.isIn(i);
            res = new Ident(n, pointer, i, true);
            if(lex.getSymb() == LexAn.lzavorka) {
                lex.srovnej(LexAn.lzavorka);
                ((Ident) res).setParam(inListIdent());
                lex.srovnej(LexAn.pzavorka);
            }
            break;
        default:
            System.out.println("Ocekavan cislo, retezec, identifikator - " +  lex.getSymb());
            System.out.println("Pozice: " + lex.getPos());
            System.exit(1);
        }
        return res;
    }
}
