package semestralka;

import java.io.File;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author not attributable
 * @version 1.0
 */
public class LexAn {
    final static int Err = -2;
    final static int EOF = -1;
    final static int NULL = 0;
    final static int hash = 1;
    final static int bc = 2;
    final static int kw = 3;
    final static int nl = 4;
    final static int include = 5;
    final static int define = 6;
    final static int mensi = 7;
    final static int vetsi = 8;
    final static int uvozovky = 9;
    final static int ident = 11;
    final static int krat = 12;
    final static int lzavorka = 13;
    final static int pzavorka = 14;
    final static int carka = 15;
    final static int strednik = 16;
    final static int kwfor = 17;
    final static int kwif = 18;
    final static int kwwhile = 19;
    final static int lslozena = 20;
    final static int pslozena = 21;
    final static int rovnase = 22;
    final static int kwelse = 23;
    final static int op = 24;
    final static int num = 26;
    final static int nerovnase = 27;
    final static int kwreturn = 28;

    private String word;
    private int symb = NULL;
    private InputReader in;

    public LexAn(File file) {
        in = new InputReader(file);
    }

    public String getPos() {
        return in.getPos();
    }

    public int read() {
        word = null;
        StringBuffer buf = new StringBuffer();
        int c = in.read();
        while(c == ' ' || c == '\t' || c == '\r') {
            c = in.read();
        }
        if(c == -1) {
            System.out.println("EOF");
            return symb = EOF;
        }
        else if(c == '\n') {
            return symb = nl;
        }
        else if(isAlpha(c)) {
            symb = ident;
            while(isAlpha(c) || isDigit(c)) {
                buf.append((char) c);
                c = in.read();
            }
            in.unget(c);
            isKey(buf.toString());
        }
        else if(isDigit(c)) {
            symb = num;
            while(isDigit(c)) {
                buf.append((char) c);
                c = in.read();
            }
            in.unget(c);
        }
        else if(c == '*') {
            symb = krat;
            buf.append((char) c);
        }
        else if((c == '+') || (c == '-') || (c == '/') || (c == '%')) {
            symb = op;
            buf.append((char) c);
            if(c == '/') {
                c = in.read();
                if (c == '*') {
                    buf.append((char) c);
                    symb = bc;
                } else {
                    in.unget(c);
                }
            }
        }
        else if(c == '<') {
            symb = mensi;
            buf.append("&lt;");
            c = in.read();
            if (c == '=') {
                buf.append((char) c);
            } else {
                in.unget(c);
            }
        }
        else if (c == '>') {
            symb = vetsi;
            buf.append("&gt;");
            c = in.read();
            if (c == '=') {
                buf.append((char) c);
            } else {
                in.unget(c);
            }
        }
        else if(c == '!') {
            buf.append((char) c);
            symb = nerovnase;
            c = in.read();
            if (c == '=') {
                buf.append((char) c);
            } else {
                symb = Err;
            }

        }
        else if(c == '=') {
            symb = rovnase;
            buf.append((char) c);
            c = in.read();
            if(c == '=') {
                buf.append((char) c);
            } else {
                in.unget(c);
            }
        }
        else if(c == '(') {
            symb = lzavorka;
            buf.append((char) c);
        }
        else if(c == ')') {
            symb = pzavorka;
            buf.append((char) c);
        }
        else if(c == '{') {
            symb = lslozena;
            buf.append((char) c);
        }
        else if(c == '}') {
            symb = pslozena;
            buf.append((char) c);
        }
        else if(c == '#') {
            symb = hash;
            buf.append((char) c);
        }
        else if(c == '"') {
            symb = uvozovky;
            buf.append((char) c);
        }
        else if(c == ';') {
            symb = strednik;
            buf.append((char) c);
        }
        else if(c == ',') {
            symb = carka;
            buf.append((char) c);
        }
        word = buf.toString();
        return symb;
    }

    public void isKey(String str) {
        if(str.equals("for")) {
            symb = kwfor;
        }
        else if(str.equals("if")) {
            symb = kwif;
        }
        else if(str.equals("while")) {
            symb = kwwhile;
        }
        else if(str.equals("else")) {
            symb = kwelse;
        }
        else if(str.equals("include")) {
            symb = include;
        }
        else if(str.equals("define")) {
            symb = define;
        }
        else if(str.equals("return")) {
            symb = kwreturn;
        }
        else if(str.equals("int") || str.equals("float") || str.equals("char")) {
            symb = kw;
        }

    }

    public int getSymb() {
        return (symb == NULL ? read() : symb);
    }

    public boolean srovnej(int what) {
        if(getSymb() == what) {
            symb = NULL;
            return true;
        }
        else {
            System.out.println("Chyba srovnani " + what + ", " + getSymb());
            System.out.println("Pozice: " + in.getPos());
            System.exit(1);
        }
        return false;
    }

    public String srovnejIdent() {
        if(getSymb() == ident) {
            symb = NULL;
            return word;
        }
        else {
            System.out.println("Ocekavan identifikator");
            System.out.println("Pozice: " + in.getPos());
            System.exit(1);
        }
        return null;
    }

    public String srovnejKw() {
        if(getSymb() != kw) {
            System.out.println("Ocekavan int, float, char");
            System.out.println("Pozice: " + in.getPos());
            System.exit(1);
        }
        else {
            symb = NULL;
            return word;
        }
        return null;
    }

    public String srovnejString(String end) {
        StringBuffer res = new StringBuffer();
        int c;
        do {
            c = in.read();
            res.append((char) c);
            if(res.length() >= end.length()) {
                if(res.substring(res.length() - end.length()).equals(end)) {
                    break;
                }
            }
        }
        while(c != -1);
        int i = 0;
        while(i < res.length()) {
            if(res.charAt(i) == ' ') {
                res.replace(i, i + 1, "&nbsp;");
            }
            else if(res.charAt(i) == '\n') {
                res.replace(i, i + 1, "<br />");
                i += 5;
            }
            else if(res.charAt(i) == '<') {
                res.replace(i, i + 1, "&lt;");
            }
            else if(res.charAt(i) == '>') {
                res.replace(i, i + 1, "&gt;");
            }
            i++;
        }
        return res.toString();
    }

    public String srovnejOp() {
        if(getSymb() == op) {
            symb = NULL;
            return word;
        }
        else {
            System.out.println("Ocekavan operator");
            System.out.println("Pozice: " + in.getPos());
            System.exit(1);
        }
        return null;
    }

    public String srovnejComOp() {
        if((getSymb() == rovnase) || (getSymb() == nerovnase) || (getSymb() == mensi) || (getSymb() == vetsi)) {
            symb = NULL;
            return word;
        }
        else {
            System.out.println("Ocekavan operator porovnani");
            System.out.println("Pozice: " + in.getPos());
            System.exit(1);
        }
        return null;
    }

    public String srovnejNum() {
        if(getSymb() == num) {
            symb = NULL;
            return word;
        }
        else {
            System.out.println("Ocekavan cislo");
            System.out.println("Pozice: " + in.getPos());
            System.exit(1);
        }
        return null;
    }

    private boolean isAlpha(int c) {
        if(c == '_') {
            return true;
        }
        if((c >= 'a') && (c <= 'z')) {
            return true;
        }
        if((c >= 'A') && (c <= 'Z')) {
            return true;
        }
        return false;
    }

    private boolean isDigit(int c) {
        if((c >= '0') && (c <= '9')) {
            return true;
        }
        return false;
    }
}
