package semestralka;

import java.io.*;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author not attributable
 * @version 1.0
 */
public class Ident extends Node {
    private String ident, p;
    private Node param;
    private int num;
    private boolean params = false;
    private boolean usage = false;

    public Ident(int num, String pointer, String ident) {
        this.ident = ident;
        p = pointer;
        this.num = num;
    }

    public Ident(int num, String pointer, String ident, boolean usage) {
        this.ident = ident;
        p = pointer;
        this.num = num;
        this.usage = true;
    }

    public void setParam(Node param) {
        this.param = param;
        params = true;
    }

    protected void print(BufferedWriter out) {
        try {
            out.write(p);
            if (usage) {
                if (num == 0) {
                    out.write("<a class=\"notdef\">" + ident + "</a>");
                    if (params) {
                        out.write("(");
                        if(param != null) {
                            param.printAll(out);
                        }
                        out.write(")");
                    }
                } else {
                    out.write("<a href=\"#" + num + "\">" + ident + "</a>");
                    if (params) {
                        out.write("(");
                        if(param != null) {
                            param.printAll(out);
                        }
                        out.write(")");
                    }
                }
            } else {
                out.write("<a name=\"" + num + "\">" + ident + "</a>");
                if (params) {
                    out.write("(");
                    if(param != null) {
                        param.printAll(out);
                    }
                    out.write(")");
                }
            }
        }
        catch(IOException e) {
            System.out.println("Chyba zapisu");
            System.exit(1);
        }
    }
}
