// nahoda.cpp
//definice funkci transformujicich nahodna cisla

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include<time.h>

//nahoda-trida generatoru podle rozlozeni s hustotou f
//vylucovaci metoda
//a..b - rozsah generatoru
//m - maximum f

#define MAXINT  32767



class nahoda
				 {
public:
	double a,b,m;
	double p[10];              //parametry pro funkci f
	double virtual f(double x)=0;
	double rnd();
	double max1();
					};

//trida histo, monitorujici nahodnou velicinu
class histo
	{
		int vh;
		public:
		double h1[50];          //h1-pole mezi intervalu
		int h2[50];            //h2-pole citacu
		double h3[50];          //h3-pole pravdepodobnosti
		double h4[50];
		int n;                 //n-pocet zadanych hodnot
		int m;                 //m-pocet intervalu
		void his(double c, int k);
		void p();
		double rnd();
		histo();
	};

int random (int x) 
{ 
	return rand()%x;
}

double real()
//rovnomerne rozlozena nahodna cisla z <0;1)
	{
		double z=MAXINT;
		return (random(MAXINT)/z);
	}

double real1()
//rovnomerne rozlozena nahodna cisla z <0;1>
	{
		double z=MAXINT-1;
		return (random(MAXINT)/z);
	}

histo::histo()
//konstruktor
	{
		int i;
		for (i=0; i<=50; i++)
						{
							h2[i]=0;     //nulovani h2
							h1[i]=0;
						}
		n=0;                               //nulovani n
		vh=1;
	}

void histo::p()
//z h2 spocita h3, pravdepodobnosti jednotlivych intervalu
	{
		int i;
		for (i=0; i<=m; i++) h3[i]=h2[i]/(n*1.0);
	}

void histo::his(double c, int k)
//vznikla udalost
//c-sledovana hodnota
//k-o kolik zvysit citac
	{
		vh=1;
		int i=0;
		while ((c>h1[i+1]) && (i<m))      //hledani intervalu
														i++;
		h2[i]=h2[i]+k;                    //citani
		n=n+k;                            //pocet zadanych hodnot
	}

double histo::rnd()
//generuje nahodne cislo podle histo rozlozeni
//hodnoty vetsi nez interval jsou ignorovany
	{
		int i;
		if (vh)
			 for (i=0; i<m; i++)                //P jednotlivych intervalu
						 h4[i]=1.0*h2[i]/(n-h2[m]);
		vh=0;
		double f=real();
		i=0;
		double s=h4[0];
		while (s<f)                           //nalezeni intervalu
			 {
				 i++;
				 s=s+h4[i];
			 }
		s=s-h4[i];
		if (h4[i]==0) return h1[0];
		double z=(f-s)/h4[i];                  //relativni poloha v intervalu
		double r=h1[i]+(h1[i+1]-h1[i])*z;      //vysledek
		return r;
	}

double sqr(double x)
//mocnina
	{
		return (x*x);
	}

int draw(double a)
//a - pravdepodobnost "1"
//1-a - pravdepodobnost "0"
	{
		if (random(100)<(a*100))
											 return 1;
									else return 0;
	}

int randint(int a, int b)
//cele cislo z <a;b> se stejnou pravdepodobnosti
	{
		return (random(b-a+1)+a);
	}

double uniform(double a, double b)
//desetinne cislo z <a;b> se stejnou pravdepodobnosti
	{
		return (a+(b-a)*real1());
	}

double negexp(double a)
//exponencialni rozlozeni se stredni hodnotou 1/a
	{
		double x=real1();
		while (x==0) x=real1();
		return (-log(x)/a);
	}

int poisson(double a)
//poissonovo rozlozeni s parametrem a
	{
		double h=exp(-a);
		double n=real();
		int i=0;
		while (n>=h)
			{
				n*=real();
				i++;
			}
		return(i);
	}

int discrete(double a[])
//diskretni rozlozeni
//F(x)=a[x]
	{
		double r=real1();
		int i=0;
		while (a[i]<r)
								i++;
		return i;
	}

double linear(double a[], double b[])
//spojite rozlozeni
//a[x]=F(b[x])
	{
		int i=0;
		double r=real1();
		while (a[i]<r) i++;
		return (b[i-1]+(r-a[i-1])/(a[i]-a[i-1])*(b[i]-b[i-1]));
	}

int histd(double a[], int k, int l)
//diskretni rozlozeni
//P(x)=a[x]
//<k;l>
	{
		double b[100];
		b[0]=a[k];
		for (int i=1; i<=(l-k); i++)
					 b[i]=b[i-1]+a[k+i];         //vypocet F
		return (k+discrete(b));            //volani discrete
	}

double normal(double n, double s)
//normalni (gauss) rozlozeni
//n - stredni hodnota
//s - standartni odchulka
	{
		double x=0;
		for (int i=1; i<=12; i++)
								x=x+real1();
		x=x-6;
		x=x*s+n;
		return x;
	}

// f

double nahoda::max1()
//numericky najde maximum fce f a zvysi ho o 10%
	{
		double k=(b-a)/10000;
		double mm=0;
		double i=a;
		while (i<=b)
				{
					if (f(i)>mm) mm=f(i);
					i=i+k;
				}
		return mm;
	}

double nahoda::rnd()
//generuje nahodne cislo podle hustoty f
//vylucovaci metoda
	{
		 double r,s;
		 do
			 {
				 r=uniform(a,b);
				 s=uniform(0,m);
			 }
		 while (f(r)<s);
		 return (r);
	}

