// knihovna Simulation
// Poskytuje zakladni tridy pro diskretni simulaci
//////////////////////////////////////////////////////////////////////

#if !defined(SIMULATION_H__INCLUDED_)
#define SIMULATION_H__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

//#include "WinSim.h"
#include "Simset.h"


//////////////////////////////////////////////////////////////////////
// Thread.h: interface for the CThread class.
// Zapouzdruje vlastnosti vlakna Win9x/NT
//////////////////////////////////////////////////////////////////////

#include <windows.h>

class CThread 
{
	
public:

	DWORD threadID;				// identifikace vlakna
	HANDLE hThread;				// handle provadeciho toku

	// fce volana z ThreadProc pro konkretni objekt vlakna
	// je v ni popsano vlastni chovani vlakna

protected:
	virtual DWORD Start() = 0;
	void InitThread();	
	// hlavni funkce vlakna, nutno deklarovat jako static
private:

	static DWORD WINAPI ThreadProc(void *);
	HANDLE Event;
	
public:

	DWORD Suspend();
	DWORD Resume();
				
	CThread();
	virtual ~CThread();

};

//////////////////////////////////////////////////////////////////////
// Process.h: interface for the CProcess class.
// popis procesu vcetne metod pro jeho planovani
// obdoba tridy process + planovaci metody tridy SIMULATION jazyka Simula67
//////////////////////////////////////////////////////////////////////

#define EVENT_IDLE -1	

class CEventNotice;

enum CODE {DIRECT, AT, DELAY, BEFORE, AFTER};
		// presnejsi specifikace planovaciho prikazu

typedef double TIME;

/*******************************************************************/
// definice planovacich maker Activate a Reactivate

#define Activate() _activate(false, DIRECT, 0, NULL, false)
#define ActivateAt(t) _activate(false, AT, t, NULL, false)
#define ActivateAtPrior(t) _activate(false, AT, t, NULL, true)
#define ActivateDelay(t) _activate(false, DELAY, t, NULL, false)
#define ActivateDelayPrior(t) _activate(false, DELAY, t, NULL, true)
#define ActivateBefore(r) _activate(false, BEFORE, 0, r, false)
#define ActivateAfter(r) _activate(false, AFTER, 0, r, false)
#define Reactivate() _activate(true, DIRECT, 0, NULL, false)
#define ReactivateAt(t) _activate(true, AT, t, NULL, false)
#define ReactivateAtPrior(t) _activate(true, AT, t, NULL, true)
#define ReactivateDelay(t) _activate(true, DELAY, t, NULL, false)
#define ReactivateDelayPrior(t) _activate(true, DELAY, t, NULL, true)
#define ReactivateBefore(r) _activate(true, BEFORE, 0, r, false)
#define ReactivateAfter(r) _activate(true, AFTER, 0, r, false)

/*******************************************************************/

class CProcess : public CLink, public CThread
{

private: bool terminated;	// true pokud je proces ukonceny

public:
    static CHead* SQS;	  // seznam SQS spolecny pro vsechny procesy

	CEventNotice* event;  // odkaz na zaznam o udalosti tohoto procesu
	
	CProcess* NextEv();
	TIME EvTime();

	static CProcess* Current();
	static CEventNotice* FirstEv();
	static TIME Time();
	
	virtual void Run() = 0;		// touto metodou uzivatel popisuje
								// vlastni chovani procesu
	bool Idle();
	bool Terminated();
	
	void _activate(bool reac, CODE code, TIME t, CProcess* r, bool prior);
	void Cancel(CProcess* p);
	void Wait(CHead* S);
	void Passivate();
	void Hold(TIME T);
	
	CProcess(bool createThread = true);
	virtual ~CProcess();

private:
	DWORD Start();
	void ResumeCurrent();

};

//////////////////////////////////////////////////////////////////////
// Simulation.h: interface for the CSimulation class.
// Proces popisujici objekt CSimulation, zakladni tridy pro simulaci
//////////////////////////////////////////////////////////////////////

class CSimulation : public CProcess
{
public:
	void Run(); // popisuje vlastni cinost procesu, nutne nadefinovat
	
	CSimulation(BOOL run = true);
	virtual ~CSimulation();
};


//////////////////////////////////////////////////////////////////////
// EventNotice.h: interface for the CEventNotice class.
// Popisuje zaznam o udalosti pro planovani procesu
// obdoba tridy EVENT NOTICE z jazyka Simula 67
//////////////////////////////////////////////////////////////////////

class CProcess;

class CEventNotice : public CLink  
{

public:
	void SetName();
	CProcess* proc;			// odkaz na planovany proces
	TIME evTime;			// cas aktivace procesu

	void Rank(bool before);

	CEventNotice(TIME time, CProcess* p);
	virtual ~CEventNotice();

};

#endif // !defined(SIMULATION_H__INCLUDED_)
