// Linkage.h: interface for the CLinkage class.
// Trida popisuje obecne vlastnosti prvku seznamu CHead a CLink
// obdoba tridy linkage v Simule 67
//////////////////////////////////////////////////////////////////////

#if !defined(SIMSET_H__INCLUDED_)
#define SIMSET_H__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <string>
using namespace std;                	// pouziti tridy string jazyka c++

class CLink;

class CLinkage  
{
public:
	string name;		                 // jmeno prvku CLinkage

	CLinkage* pred;	                	//ukazatel na predchudce
	CLinkage* suc;                      //ukazatel na nasledovnika

	string GetName();                   // vraci name
	void SetName(string newName);       // nastavi name
	
	virtual CLink* Pred() = 0;  // vraci dalsi polozku v seznamu
	virtual CLink* Suc() = 0;   // predchozi polozka v seznamu

	virtual bool IsHead() {return false;}  // vraci true, jedna-li se o hlavu seznamu

	CLinkage();
	virtual ~CLinkage();

};

// Head.h: interface for the CHead class.
// Definice vlastnosti polozky seznamu
// Obdoba tridy head v jazyku Simula 67
//////////////////////////////////////////////////////////////////////

class CHead : public CLinkage  
{
public:

	CLink* Last();               // vraci ukazatel na posledni polozku seznamu
	CLink* First();              // vraci ukazatel na prvni polozku seznamu
	CLink* Suc();                // vraci odkaz na nasledujici polozku
	CLink* Pred();               // vraci odkaz na predchazejici polozku

	void Clear();                // vyprazdni cely seznam
	int Cardinal();              // vraci pocet polozek seznamu
	bool Empty();                // indikuje prazdny seznam

	inline bool IsHead() {return true;}     // indikuje hlavu seznamu

	CHead();
	virtual ~CHead();

	void EnableInfo(bool enable);           // nastavi enableInfo
	
	bool enableInfo;		    // hodnota povoluje nebo zakazuje generovani retezce list
	string list;				// pri enableInfo == true
								// obsahuje seznam objektu celeho seznamu (pro ladici ucely)
								 
protected:
	string* RefreshList();       // vraci odkaz na list
	
	friend class CLink;
};

// Link.h: interface for the CLink class.
// Definice vlastnosti polozky seznamu
// obdoba tridy link jazyka Simula 67
//////////////////////////////////////////////////////////////////////

class CLink : public CLinkage  
{
private:
	CHead* head;
public:
	CLink* Suc();    // vraci odkaz na nasledovnika, NULL je-li v seznamu jediny objekt
	CLink* Pred();   // vraci odkaz na predchudce, NULL je-li jediny

	void Precede (CLinkage* l);  // zaradi tento objekt do seznamu pred l
	void Follow(CLinkage* l);    // zaradi tento objekt do seznamu za l
	void Into(CHead* h);         // zaradi tento objekt na konec seznamu h
	void Out();                  // vyjme tento objekt ze seznamu(je-li, jinak nic)                 

	CLink();
	virtual ~CLink();
};
 
#endif // !defined(SIMSET_H__INCLUDED_)

