
#include "simulation.h"
#include "random.h"
#include<time.h>
//-------------------------------SHO demo-------------------------------- 
class TService;

CHead     *Queue, *PQueue;                              
TService  *Service;                              


class TRequest : public CProcess                 // request in the queueing system
{                     
  virtual void Run();                            // request's behaviour
};


class TService : public CProcess                 // process servicing requests
{                                                 
  virtual void Run();                            // service's behaviour
};

void TRequest::Run()                           
{
  int prior = draw(0.2);
  if(prior) printf("Incoming priority %f\n",Time ());
  else printf("Incoming %f\n",Time ());
  (new TRequest)->ActivateDelayPrior(negexp(0.25));               // scheduling incoming of next request
  if (PQueue->Empty() && Queue->Empty()) {                            // if the queue is empty 
    if(prior) Into(PQueue);                                  // inserting request into queue
    else Into(Queue);                                  // inserting request into queue
    printf("Waking up service ....\n");             
    Service->ActivateAt(Time ());                  // waking up service process
  } else {
    if(prior) {
      Into(PQueue);                                  // inserting request into queue
      printf("There is/are %d prior request(s) in the queue, ranking ...\n",PQueue->Cardinal());
      printf("There is/are %d request(s) in the queue\n",Queue->Cardinal());
	} else {
      Into(Queue);                                  // inserting request into queue
      printf("There is/are %d prior request(s) in the queue\n",PQueue->Cardinal());
      printf("There is/are %d request(s) in the queue, ranking ...\n",Queue->Cardinal());
	}
  }
  printf("Going to sleep ... \n");
  Passivate();                                      // waiting for the finishing the service
  printf("Leaving system %f\n",Time ());
}

void TService::Run()                               
{
  CProcess* P;                                       // temp. variable
  while(true) {
     if (PQueue->Empty() && Queue->Empty()) {
       printf("Queues are empty, going to sleep ... \n");
       Passivate();                                 // service is waiting for incoming requests
     } else if(!PQueue->Empty()) {
       printf("Begin of priority service in %f\n",Time ());     // in the queue, there is at least one request
       P=(CProcess*)PQueue->First();                
       P->Out();                                      // removing the request from the queue
       Hold(5);                             // servicing time (mean value 50 )
       P->ActivateAt (Time());                        // executing request
       printf("End of priority service in %f\n",Time ());
     } else {
       printf("Begin of service in %f\n",Time ());     // in the queue, there is at least one request
       P=(CProcess*)Queue->First();                
       P->Out();                                      // removing the request from the queue
       Hold(5);                             // servicing time (mean value 50 )
       P->ActivateAt (Time());                        // executing request
       printf("End of service in %f\n",Time ());
     }
  }
}
/*----------------------------------------------*/
void CSimulation::Run()                          // main process
{
  printf("--- Demonstration of SIMULATION module -- time %f\n", Time());

  srand( (unsigned) time(NULL) );               // inicialization on random number generator
  Service = new TService();                      // creating service process
  Queue  = new CHead();                          // creating instance of queue
  PQueue  = new CHead();                          // creating instance of queue
  (new TRequest)->ActivateAt(Time ());           // creating and scheduling 1st request
  
  Hold(4*60);                                     // waiting before simulation end
  printf("\nPriority queue length: %ld\n", PQueue -> Cardinal());
  printf("Queue length: %ld\n\n", Queue -> Cardinal());
  printf("End of simulation --- time: %f\n\n", Time ());
  exit(0);
};
