unit Textak;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, Menus, Buttons, ExtCtrls,Clipbrd;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Memo1: TMemo;
    StatusBar1: TStatusBar;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    FontDialog1: TFontDialog;
    Soubor1: TMenuItem;
    Nov1: TMenuItem;
    Otevt1: TMenuItem;
    Uloit1: TMenuItem;
    Zavt1: TMenuItem;
    N1: TMenuItem;
    Konec1: TMenuItem;
    Nastaven1: TMenuItem;
    Zobrazovat1: TMenuItem;
    Vbrpsma1: TMenuItem;
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    pravy1: TMenuItem;
    koprovat1: TMenuItem;
    Vyznout1: TMenuItem;
    Vloit1: TMenuItem;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
//    function Clipboard: TClipboard;
    procedure UpdateStatusBar;
    procedure Memo1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Memo1KeyPress(Sender: TObject; var Key: Char);
    procedure Memo1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Nov1Click(Sender: TObject);
    procedure Otevt1Click(Sender: TObject);
    procedure Uloit1Click(Sender: TObject);
    procedure Zavt1Click(Sender: TObject);
    procedure Konec1Click(Sender: TObject);
    procedure Zobrazovat1Click(Sender: TObject);
    procedure Vbrpsma1Click(Sender: TObject);
    procedure StatusBar1Hint(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure koprovat1Click(Sender: TObject);
    procedure Vyznout1Click(Sender: TObject);
    procedure Vloit1Click(Sender: TObject);
    procedure Memo1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Memo1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var s: string;
begin
  case Key of
    16,17,18: exit;
    45: if Length(StatusBar1.Panels.Items[1].text)>0 then
           StatusBar1.Panels.Items[1].Text:=''
        else StatusBar1.Panels.Items[1].Text:='INS';
        end;
  if Zobrazovat1.Checked then begin
    s:='Stisknuta klvesa . '+IntToStr(Key)+#13#10+' Modifiktory:';
    if (ssShift in Shift) then s:=s+ ' Shift';
    if (ssAlt in Shift) then s:=s+' Alt';
    if (ssCtrl in Shift) then s:=s+' Ctrl';
    ShowMessage(s);
    end;


end;

procedure TForm1.Memo1KeyPress(Sender: TObject; var Key: Char);
var s:string;
    pos:integer;
begin
  if Length(StatusBar1.Panels.Items[1].Text)=0 then
    if (Memo1.SelLength=0) and (ord(Key)<>8) and (ord(Key)<>13) and (Memo1.Text[Memo1.SelStart+1]<>#13) then begin
      s:=Memo1.Text;
      pos:=Memo1.SelStart;
      Delete(s,pos+1,1);
      Memo1.Text:=s;
      Memo1.SelStart:=pos;
    end;  

end;

procedure TForm1.Memo1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var temp: boolean;
begin
  UpdateStatusBar;
  temp:=Memo1.SelLength >0;
  Vyznout1.Enabled:=temp;
  Koprovat1.Enabled:=temp;
  SpeedButton7.Enabled:=temp;
  SpeedButton8.Enabled:=temp;
end;

procedure TForm1.UpdateStatusBar;
begin
  StatusBar1.Panels.Items[2].Text:= 'Znak: '+ IntToStr(Length(Memo1.Text));
  if not Memo1.Modified then StatusBar1.Panels.Items[3].Text:=''
  else if StatusBar1.Panels.Items[3].Text='' then begin
    StatusBar1.Panels.Items[3].Text:='Zmnno';
    SpeedButton1.Enabled:=true;
    SpeedButton3.Enabled:=true;
    SpeedButton4.Enabled:=true;
    Nov1.Enabled:=true;
    Uloit1.Enabled:=true;
    Zavt1.Enabled:=true;
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnHint:=StatusBar1Hint;
  UpdateStatusBar;
  SpeedButton1.Enabled:=false;
  SpeedButton3.Enabled:=false;
  SpeedButton4.Enabled:=false;
  Nov1.Enabled:=false;
  Uloit1.Enabled:=false;
  Zavt1.Enabled:=false;
  Vloit1.Enabled:=Clipboard.HasFormat(CF_TEXT);
  SpeedButton9.Enabled:=Clipboard.HasFormat(CF_TEXT);
  Konec1Click(self);
  Zobrazovat1.Click();
  Vyznout1.Enabled:=false;
  Koprovat1.Enabled:=false;
  SpeedButton7.Enabled:=false;
  SpeedButton8.Enabled:=false;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Memo1.Modified then
    if MessageDlg('Soubor nen uloen. Uloit zmny?',mtWarning,[mbYes,mbNo],0) =mrYes then
      Uloit1Click(self);

end;

procedure TForm1.Nov1Click(Sender: TObject);
begin
  if Memo1.Modified then
    if MessageDlg('Soubor nen uloen. Uloit zmny?',mtWarning,[mbYes,mbNo],0) =mrYes then
      Uloit1Click(self);
  Memo1.Lines.Clear;
  UpdateStatusBar;
  SpeedButton1.Enabled:=false;
  SpeedButton3.Enabled:=false;
  SpeedButton4.Enabled:=false;
  Nov1.Enabled:=false;
  Uloit1.Enabled:=false;
  Zavt1.Enabled:=false;

end;

procedure TForm1.Otevt1Click(Sender: TObject);
begin
  if Memo1.Modified then
    if MessageDlg('Soubor nen uloen. Uloit zmny?',mtWarning,[mbYes,mbNo],0) =mrYes then
      Uloit1Click(self);
  if OpenDialog1.Execute then begin
    Memo1.Lines.Clear;
    Memo1.Lines.LoadFromFile(OpenDialog1.FileName);
    UpdateStatusBar;
    SpeedButton1.Enabled:=true;
    SpeedButton3.Enabled:=true;
    SpeedButton4.Enabled:=true;
    Nov1.Enabled:=true;
    Uloit1.Enabled:=true;
    Zavt1.Enabled:=true;
    end;

end;

procedure TForm1.Uloit1Click(Sender: TObject);
begin
  if SaveDialog1.Execute then Memo1.Lines.SaveToFile(SaveDialog1.FileName);
  UpdateStatusBar;

end;

procedure TForm1.Zavt1Click(Sender: TObject);
begin
  Nov1Click(self);

end;

procedure TForm1.Konec1Click(Sender: TObject);
begin
  Nov1Click(self);
  Close;

end;

procedure TForm1.Zobrazovat1Click(Sender: TObject);
begin
  Zobrazovat1.Checked:= not Zobrazovat1.Checked

end;

procedure TForm1.Vbrpsma1Click(Sender: TObject);
begin
  if FontDialog1.Execute then Memo1.Font:=FontDialog1.Font;

end;

procedure TForm1.StatusBar1Hint(Sender: TObject);
begin
  StatusBar1.Panels.Items[0].Text:=Application.Hint;

end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  Nov1Click(self);
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  Otevt1Click(self);
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  Uloit1Click(self);
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
  Zavt1Click(self);
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
  Vbrpsma1Click(self);
end;

procedure TForm1.SpeedButton6Click(Sender: TObject);
begin
  Konec1Click(self);
end;

procedure TForm1.koprovat1Click(Sender: TObject);
begin
  Memo1.CopyToClipboard;
  Vloit1.Enabled:=true;
  SpeedButton9.Enabled:=true;
end;

procedure TForm1.Vyznout1Click(Sender: TObject);
begin
  Memo1.CutToClipboard;
  Vloit1.Enabled:=true;
  SpeedButton9.Enabled:=true;
end;

procedure TForm1.Vloit1Click(Sender: TObject);
begin
  Memo1.PasteFromClipboard;
  SpeedButton1.Enabled:=true;
  SpeedButton3.Enabled:=true;
  SpeedButton4.Enabled:=true;
  Nov1.Enabled:=true;
  Uloit1.Enabled:=true;
  Zavt1.Enabled:=true;
end;

procedure TForm1.Memo1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var temp: boolean;
begin
  temp:=Memo1.SelLength >0;
  Vyznout1.Enabled:=temp;
  Koprovat1.Enabled:=temp;
  SpeedButton7.Enabled:=temp;
  SpeedButton8.Enabled:=temp;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  Vloit1.Enabled:=Clipboard.HasFormat(CF_TEXT);
end;

end.
