#include <stdlib.h>
#include "readFile.h"

#define LINE 1024

void readLine(FILE * fin);
void readCNF(char * line);
void readWeights(FILE * fin);
void readClause(FILE * fin);

bool loadData(FILE * fin) {
		bool ret = true;
		char c;
		char line[LINE] = "";
		do {
				fscanf_s(fin, "%c", &c);
				if((c == 'c') || (c == 'p')) {
						fgets(line, LINE, fin);
				}
		} while(c == 'c');
		
		if(c != 'p') {
				printf("Chyba ve vstupu\n");
				exit(1);
		}
		readCNF(&line[4]);

		fscanf_s(fin, "%c", &c);
		if(c == 'w') {
				readWeights(fin);
				ret = false;
		} else {
				ungetc(c, fin);
		}

		readClause(fin);

		return ret;
}

void readClause(FILE * fin) {
		int line = 0;
		while(!feof(fin)) {
				cnf[line] = new int[100];
		
				int v = 0;
				int count = 0;
				do {
						fscanf_s(fin, "%d" , &v);
						if((v > variables) || (v < -variables)) {
								printf("Promena mimo hodnoty\n");
								exit(1);
						} else if(count > 100) {
								printf("Prilis mnoho clenu klauzule\n");
								exit(1);
						}
						count++;
						cnf[line][count] = v;
				} while (v != 0);
				cnf[line][0] = count;
				line++;
		}
}

void readWeights(FILE * fin) {
		maxWeight = 0;
		int w;
		for(int i = 0; i < variables; i++) {
				fscanf_s(fin, "%d", &w);
				weights[i] = w;
				if(w > maxWeight) maxWeight = w;
		}
}

void readCNF(char * line) {
		sscanf_s(line, "%d %d", &variables, &clauses);

		if(variables > 64) {
				printf("Prilis mnoho promennych\n");
				exit(1);
		}

		cnf = new int * [clauses];
		weights = new int[variables];
}