#define _WIN32_WINNT 0x0400

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "readFile.h"
#include "annealing.h"
#include "global.h"
#include "osdir.h"

#define MAXWEIGHT 10

int variables;
int clauses;
int * weights;
int maxWeight;
int ** cnf;
FILE *flog;

void generateWeights() {
		maxWeight = 0;
		for(int i = 0; i < variables; i++) {
				int weight = rand() % MAXWEIGHT;
				weights[i] = weight;
				if(weight > maxWeight) maxWeight = weight;
		}
}

void printFile() {
		for(int i = 0; i < clauses; i++) {
				for(int j = 1; j < cnf[i][0]; j++) {
						printf("%d ", cnf[i][j]);
				}
				printf("\n");
		}

		printf("\n");
		for(int i = 0; i < variables; i++) {
				printf("%d ", weights[i]);
		}
		printf("\n");
}

void processFile(int count, char *fileName) {
		FILE *fin;
		if(fopen_s(&fin, fileName, "r") != 0) {
				printf("Nelze otevrit %s\n", fileName);
				return;
		} else {
				printf("Processing: %s\n", fileName);
		}

		if(loadData(fin))
				generateWeights();
//		printFile();

		if(count == 1) {
				char logName[50];
				sprintf_s(logName, 50, "output\\%s.log", &fileName[6]);
				fopen_s(&flog, logName, "w");
				State best = {0,0,0};
				for(int i = 0; i < 5; i++) {
						State n = annealing();
						if(n.cost > best.cost) best = n;
				}
				print(best);
				fclose(flog);
		} else {
				time_t begin;
				time(&begin);
				for(int i = 0; i < count; i++) {
						State best = annealing();
				}
				time_t ctime = time(NULL) - begin;
				printf("time: %f\n\n", (float) ctime / count);
		}
/*
		printf("Deleting...\n"); fflush(stdout);
		delete [] weights;
		printf("Weights OK\n"); fflush(stdout);
		for(int i = 0; i < clauses; i++) {
				delete [] cnf[i];
				printf("klauzule %d OK\n", i); fflush(stdout);
		}
		delete [] cnf;
		printf("CNF OK\n"); fflush(stdout);
*/
		fclose(fin);
}

int main(int argc, char* argv[]) {
		int count = 1;
		if(argc > 1) {
				count = atoi(argv[1]);
		}
		srand( (unsigned) time( NULL ) );

		oslink::directory dir("input");
		while (dir) {
				char fileName[128] = "input\\";
				strcat_s(fileName, 128, dir.next().c_str());
				if(fileName[strlen(fileName) -1] != '.') {
						processFile(count, fileName);
				}
		}
}
