#include "annealing.h"
#include "SAT.h"

State initState();
double initTemperature(State state);
State getNewState(State oldState, double temp);
double coolDown(double temp);
bool doInnerLoop(int iters);
bool doOuterLoop(double temp);

State annealing() {
		State state = initState();
		double t = initTemperature(state);
		State maxState = {0, 0, 0};
		log(state);

		bool terminate;
		do {
				terminate = true;
				int i = 0;
				do {
						State newState = getNewState(state, t);
						if(newState != state) {
								terminate = false;
								state = newState;
						}
						if(state.satisfied && (state.cost > maxState.cost)) maxState = state;
						log(state);
						i++;
				} while(doInnerLoop(i));
				t = coolDown(t);
		} while(!terminate && doOuterLoop(t));

		return maxState;
}

State initState() {
		State s = getSomeRandomState();
//		State s = {0, 0, 0};
		return s;
}

extern int variables;
double initTemperature(State state) {
		return variables*maxWeight/20;
}

State getNewState(State oldState, double temp) {
		State newState = getNextRandomState(oldState);
		int delta = newState.cost - oldState.cost;
		if(delta > 0) return newState;
		else {
				double r = getNormalRandom();
				if(r < exp(delta/temp)) return newState;
				else return oldState;
		} 
}

double coolDown(double temp) {
		return temp * 0.9;
}

bool doInnerLoop(int iters) {
		return iters < (variables * 5);
}

bool doOuterLoop(double temp) {
		return temp > 0.1;
}
