#include <stdlib.h>
#include "SAT.h"

void setCost(State & state) {
		state.cost = 0;
    for(int i = 0; i < variables; i++) {
				if(state.value & getLongLong(i)) {
						state.cost += weights[i];
				}
		}

		state.satisfied = true;
		for(int i = 0; i < clauses; i++) {
      bool satisfied = false;
			int length = cnf[i][0];
      for(int j = 1; j < length; j++) {
        int index = cnf[i][j];
        if((index > 0) && (state.value & getLongLong(index-1))) {
          satisfied = true;
					break;
        } else if((index < 0) && !(state.value & getLongLong(-index-1))) {
          satisfied = true;
					break;
				} else{
				}
      }
			if(!satisfied) {
					state.satisfied = false;
					state.cost -= 3*maxWeight;
			}
    }
}

void exchange(State & state, int x) {
		unsigned long long item = getLongLong(x);
		if(state.value & item)
				state.value &= ~item;
		else
				state.value |= item;
}

State getSomeRandomState() {
		State newState = {0, 0, 0};
		for(int i = 0; i < variables; i++) {
				if(getNormalRandom() < .3)
						newState.value |= getLongLong(i);
		}
		setCost(newState);
		return newState;
}

State getNextRandomState(State state) {
		State newState = state;
		int x = rand() % variables;
		exchange(newState, x);
		setCost(newState);
		return newState;
}
